<?php
// api/index.php

// Inicia a sessão
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Configurações de resposta
http_response_code(401); // Unauthorized
header('Content-Type: text/html; charset=utf-8');

// Função para renderizar a página de erro
function renderErrorPage() {
    $error_title = "Acesso Negado";
    $error_message = "Você não tem permissão para acessar este recurso. Por favor, verifique suas credenciais ou entre em contato com o suporte técnico.";
    $redirect_url = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '../';
    $redirect_time = 5; // Tempo em segundos para redirecionar
    
    echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Star 3D Midia IBO P2P">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <title>Erro de Acesso - Star 3D Midia</title>
    
    <style>
        :root {
            --primary-color: #8000FF;
            --primary-dark: #6200E6;
            --error-color: #FF5757;
            --dark-bg: #121212;
            --card-bg: rgba(30, 30, 40, 0.9);
            --text-color: #f8f9fa;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        html, body {
            width: 100%;
            height: 100%;
            overflow-x: hidden;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--dark-bg);
            background-image: 
                radial-gradient(circle at 25% 25%, rgba(128, 0, 255, 0.2) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(255, 87, 87, 0.2) 0%, transparent 50%);
            color: var(--text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
            position: relative;
        }
        
        #particles-js {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
        
        .error-container {
            background-color: var(--card-bg);
            border-radius: 16px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.08);
            padding: 2.5rem;
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: fadeIn 0.5s ease-out;
            margin: auto;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .error-icon {
            font-size: 5rem;
            color: var(--error-color);
            margin-bottom: 1.5rem;
            animation: pulse 1.5s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
        
        .error-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 1rem;
            color: var(--error-color);
            line-height: 1.2;
        }
        
        .error-message {
            font-size: 1.1rem;
            margin-bottom: 1rem;
            line-height: 1.6;
        }
        
        .redirect-info {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 1.5rem;
        }
        
        .countdown {
            font-weight: bold;
            color: var(--primary-color);
        }
        
        .btn-return {
            background-color: var(--primary-color);
            border: none;
            border-radius: 12px;
            padding: 12px 24px;
            color: white;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
            margin-top: 1rem;
            min-width: 200px;
        }
        
        .btn-return:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(128, 0, 255, 0.3);
        }
        
        .company-info {
            text-align: center;
            margin-top: 2.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        /* Responsividade Avançada */
        @media (max-width: 768px) {
            .error-container {
                padding: 1.75rem;
            }
            
            .error-icon {
                font-size: 4rem;
            }
            
            .error-title {
                font-size: 1.75rem;
            }
            
            .error-message {
                font-size: 1rem;
            }
        }
        
        @media (max-width: 576px) {
            body {
                padding: 15px;
            }
            
            .error-container {
                padding: 1.5rem;
                border-radius: 12px;
            }
            
            .error-icon {
                font-size: 3.5rem;
                margin-bottom: 1rem;
            }
            
            .error-title {
                font-size: 1.5rem;
            }
            
            .error-message, .redirect-info {
                font-size: 0.95rem;
                margin-bottom: 1rem;
            }
            
            .btn-return {
                padding: 10px 20px;
                min-width: 180px;
                font-size: 0.9rem;
            }
        }
        
        @media (max-width: 400px) {
            .error-container {
                padding: 1.25rem;
            }
            
            .error-icon {
                font-size: 3rem;
            }
            
            .error-title {
                font-size: 1.3rem;
            }
            
            .redirect-info {
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <!-- Partículas de fundo -->
    <div id="particles-js"></div>
    
    <!-- Container principal centralizado -->
    <div class="container d-flex justify-content-center align-items-center">
        <div class="error-container">
            <div class="error-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h1 class="error-title">{$error_title}</h1>
            <p class="error-message">{$error_message}</p>
            
            <p class="redirect-info">
                Redirecionando para a página de login em <span class="countdown">{$redirect_time}</span> segundos...
            </p>
            
            <a href="{$redirect_url}" class="btn-return">
                <i class="fas fa-arrow-left"></i> Voltar Agora
            </a>
            
            <div class="company-info">
                <span class="text-muted">VNM GROUP &copy; 2025</span>
            </div>
        </div>
    </div>
    
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        // Configuração das partículas
        document.addEventListener('DOMContentLoaded', function() {
            particlesJS('particles-js', {
                "particles": {
                    "number": {
                        "value": 60,
                        "density": {
                            "enable": true,
                            "value_area": 800
                        }
                    },
                    "color": {
                        "value": "#FF5757"
                    },
                    "shape": {
                        "type": "circle",
                        "stroke": {
                            "width": 0,
                            "color": "#000000"
                        }
                    },
                    "opacity": {
                        "value": 0.5,
                        "random": false
                    },
                    "size": {
                        "value": 3,
                        "random": true
                    },
                    "line_linked": {
                        "enable": true,
                        "distance": 120,
                        "color": "#FF5757",
                        "opacity": 0.3,
                        "width": 1
                    },
                    "move": {
                        "enable": true,
                        "speed": 1.5,
                        "direction": "none",
                        "random": false,
                        "straight": false,
                        "out_mode": "out"
                    }
                },
                "interactivity": {
                    "detect_on": "canvas",
                    "events": {
                        "onhover": {
                            "enable": true,
                            "mode": "grab"
                        },
                        "onclick": {
                            "enable": true,
                            "mode": "push"
                        },
                        "resize": true
                    }
                }
            });
            
            // Ajusta o canvas das partículas para ocupar toda a tela
            function resizeParticles() {
                const canvas = document.querySelector('#particles-js canvas');
                if (canvas) {
                    canvas.style.width = '100%';
                    canvas.style.height = '100%';
                }
            }
            
            window.addEventListener('resize', resizeParticles);
            resizeParticles();
            
            // Redirecionamento automático
            let seconds = {$redirect_time};
            const countdownElement = document.querySelector('.countdown');
            
            // Atualiza o contador visual
            const countdownInterval = setInterval(() => {
                seconds--;
                countdownElement.textContent = seconds;
                
                if (seconds <= 0) {
                    clearInterval(countdownInterval);
                    window.location.href = "{$redirect_url}";
                }
            }, 1000);
        });
    </script>
</body>
</html>
HTML;
}

// Renderiza a página de erro
renderErrorPage();