<?php
/*
 * @ https://hospedagem.matrixch.store 
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 17/06/2024
*/

include "includes/header.php";
$table_name = "dns";
$res = $db->select($table_name, "*", "", "");
$resU = @$db->select($table_name, "*", "id = :id", "", [":id" => $_GET["update"]]);

if (isset($_POST["submitU"])) {
    unset($_POST["submitU"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => $_GET["update"]]);
echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=5'</script>";

}

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);
    $db->insert($table_name, $_POST);
    $db->close();
echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=5'</script>";
}

if (isset($_GET["delete"])) {
    $db->delete($table_name, "id = :id", [":id" => $_GET["delete"]]);
echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=6'</script>";

}

// Add new function to delete all records
if (isset($_GET["deleteall"])) {
    $db->delete($table_name, "1=1", []);
echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=7'</script>";

}
?>

<style>
/* Main Colors - Dark Blue Theme */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --warning-orange: #fd7e14;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
    --dark-gray: #6c757d;
    --black: #212529;
}

/* Base Styles */
body {
    background-color: var(--white);
    color: var(--black);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    line-height: 1.6;
}

.container-fluid {
    padding: 20px;
    background-color: var(--white);
}

/* Card Styles - White with Blue Accents */
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    margin-bottom: 20px;
    background-color: var(--white);
    border: 1px solid var(--light-blue);
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
}

/* Form Styles */
.form-control {
    padding: 10px 15px;
    border-radius: 6px;
    border: 1px solid var(--medium-gray);
    transition: all 0.3s;
    background-color: var(--white);
}

.form-control:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 0.25rem rgba(61, 90, 254, 0.15);
}

.form-label {
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--dark-blue);
}

/* Button Styles */
.btn {
    padding: 8px 16px;
    border-radius: 6px;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary {
    background-color: var(--primary-blue);
    border-color: var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background-color: var(--dark-blue);
    border-color: var(--dark-blue);
}

.btn-outline-primary {
    color: var(--primary-blue);
    border-color: var(--primary-blue);
    background-color: transparent;
}

.btn-outline-primary:hover {
    background-color: var(--primary-blue);
    color: var(--white);
}

.btn-danger {
    background-color: var(--danger-red);
    border-color: var(--danger-red);
    color: var(--white);
}

.btn-outline-danger {
    color: var(--danger-red);
    border-color: var(--danger-red);
    background-color: transparent;
}

.btn-outline-danger:hover {
    background-color: var(--danger-red);
    color: var(--white);
}

.btn-light {
    background-color: var(--light-gray);
    color: var(--dark-blue);
    border: 1px solid var(--medium-gray);
}

.btn-light:hover {
    background-color: var(--medium-gray);
}

/* Table Styles */
.table {
    color: var(--black);
    margin-bottom: 0;
    background-color: var(--white);
}

.table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.8rem;
    letter-spacing: 0.5px;
    background-color: var(--light-blue);
    color: var(--dark-blue);
    border-bottom: 2px solid var(--medium-gray);
}

.table-hover tbody tr:hover {
    background-color: rgba(61, 90, 254, 0.05);
}

.table-striped tbody tr:nth-of-type(odd) {
    background-color: rgba(232, 234, 246, 0.3);
}

/* Modal Styles */
.modal-content {
    border: none;
    border-radius: 8px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
    background-color: var(--white);
}

.modal-header {
    border-radius: 8px 8px 0 0;
    padding: 15px 20px;
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
    color: var(--white);
}

.modal-title {
    font-weight: 600;
}

.modal-body {
    padding: 20px;
    background-color: var(--white);
}

.modal-footer {
    border-top: 1px solid var(--medium-gray);
    padding: 15px 20px;
    background-color: var(--light-gray);
}

/* Code Display */
code {
    color: var(--primary-blue);
    background-color: rgba(232, 234, 246, 0.5);
    padding: 2px 4px;
    border-radius: 4px;
    font-family: Consolas, Monaco, 'Andale Mono', monospace;
    font-size: 0.9em;
}

/* Utility Classes */
.text-center {
    text-align: center;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-4 {
    margin-top: 1.5rem !important;
}

.me-1 {
    margin-right: 0.25rem !important;
}

.me-2 {
    margin-right: 0.5rem !important;
}

.px-4 {
    padding-left: 1.5rem !important;
    padding-right: 1.5rem !important;
}

.shadow-sm {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08) !important;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
    
    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
}
</style>

<div class="container-fluid py-4">
    <?php if (isset($_GET["create"])): ?>
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-plus-circle me-2"></i>Criar DNS</h4>
                            <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-light">
                                <i class="fas fa-arrow-left me-1"></i> Voltar
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label for="title" class="form-label">Título</label>
                                <input type="text" class="form-control" id="title" name="title" placeholder="DNS Title" required>
                            </div>
                            <div class="mb-3">
                                <label for="url" class="form-label">Endereço DNS</label>
                                <input type="text" class="form-control" id="url" name="url" placeholder="e.g., 1.1.1.1 or dns.example.com" required>
                            </div>
                            <div class="text-center mt-4">
                                <button type="submit" name="submit" class="btn btn-primary px-4">
                                    <i class="fas fa-save me-2"></i>Salvar DNS
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    
    <?php elseif (isset($_GET["update"])): ?>
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-edit me-2"></i>Editar DNS</h4>
                            <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-light">
                                <i class="fas fa-arrow-left me-1"></i> Voltar
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label for="title" class="form-label">Título</label>
                                <input type="text" class="form-control" id="title" name="title" value="<?= htmlspecialchars($resU[0]['title']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="url" class="form-label">Endereço DNS</label>
                                <input type="text" class="form-control" id="url" name="url" value="<?= htmlspecialchars($resU[0]['url']) ?>" required>
                            </div>
                            <div class="text-center mt-4">
                                <button type="submit" name="submitU" class="btn btn-primary px-4">
                                    <i class="fas fa-save me-2"></i>Atualizar DNS
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    
    <?php else: ?>
        <div class="row">
            <div class="col-12">
                <?php if (isset($_GET["status"])): ?>
                    <?php if ($_GET["status"] == 5): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> O registro DNS foi salvo com sucesso.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php elseif ($_GET["status"] == 6): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> O registro DNS foi excluído com sucesso.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php elseif ($_GET["status"] == 7): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> Todos os registros DNS foram excluídos com sucesso.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <div class="card shadow-sm">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0"><i class="fas fa-network-wired me-2"></i>Gerenciamento de DNS</h4>
                            <div>
                                <?php if (count($res) > 0): ?>
                                <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>?deleteall=1" class="btn btn-danger me-2" onclick="return confirm('Are you sure you want to delete ALL DNS records? This action cannot be undone.');">
                                    <i class="fas fa-trash-alt me-1"></i> Remover tudo
                                </a>
                                <?php endif; ?>
                                <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>?create" class="btn btn-light">
                                    <i class="fas fa-plus me-1"></i> Adicionar novo
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if (count($res) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th width="25%">Título</th>
                                        <th width="50%">Endereço DNS</th>
                                        <th width="20%" class="text-center">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($res as $row): ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><?= htmlspecialchars($row['title']) ?></td>
                                        <td><code><?= htmlspecialchars($row['url']) ?></code></td>
                                        <td class="text-center">
                                            <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>?update=<?= $row['id'] ?>" class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>?delete=<?= $row['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Are you sure you want to delete this DNS record?');">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-database fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Nenhum registro DNS encontrado. Clique em "Adicionar novo" para criar um.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php 
include "includes/footer.php";
?>