<?php 
include 'includes/header.php';

// Carregar configurações existentes
if (file_exists('mensagem.txt')) {
    $data = json_decode(file_get_contents('mensagem.txt'), true);
    $mensagem = htmlspecialchars($data['mensagem']);
    $cor = htmlspecialchars($data['cor']);
    $bgcolor = htmlspecialchars($data['bgcolor']);
    $opacity = htmlspecialchars($data['opacity']);
    $fontSize = isset($data['fontSize']) ? htmlspecialchars($data['fontSize']) : "16";
} else {
    // Valores padrão
    $mensagem = "Sua mensagem aparecerá aqui";
    $cor = "#000000";
    $bgcolor = "#ffffff";
    $opacity = "1";
    $fontSize = "16";
}
?>

<style>
/* Main Colors - Dark Blue Theme (totalmente alinhado com dns.php) */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --warning-orange: #fd7e14;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
    --dark-gray: #6c757d;
    --black: #212529;
}

/* Layout Structure */
.container-fluid {
    max-width: 1200px;
    margin: 0 auto;
}

/* Card Styles */
.card {
    border: none;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    background-color: var(--white);
}

.card-header {
    padding: 18px 25px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.card-body {
    padding: 30px;
}

/* Form Elements */
.form-group {
    margin-bottom: 25px;
}

.form-label {
    display: block;
    font-weight: 500;
    margin-bottom: 10px;
    color: var(--dark-blue);
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid var(--medium-gray);
    border-radius: 6px;
    background-color: var(--white);
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 3px rgba(61, 90, 254, 0.15);
}

/* Color Pickers */
.color-picker-container {
    display: flex;
    gap: 15px;
    margin-top: 10px;
}

.color-preview-box {
    width: 40px;
    height: 40px;
    border-radius: 6px;
    border: 1px solid var(--medium-gray);
    cursor: pointer;
}

/* Range Sliders */
.range-group {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-top: 10px;
}

.range-slider {
    flex: 1;
}

.range-value {
    min-width: 50px;
    text-align: center;
    background: var(--light-gray);
    padding: 8px 12px;
    border-radius: 6px;
    font-family: monospace;
}

/* Preview Section */
.preview-section {
    background-color: var(--light-blue);
    border-radius: 10px;
    padding: 25px;
    margin: 30px 0;
    border: 1px solid var(--accent-blue);
}

.preview-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.preview-title {
    font-weight: 600;
    color: var(--dark-blue);
    margin: 0;
}

.preview-content {
    background: var(--white);
    border-radius: 8px;
    padding: 25px;
    box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
}

.preview-text {
    padding: 15px;
    border-radius: 6px;
    text-align: center;
    transition: all 0.3s ease;
}

/* Buttons */
.btn {
    padding: 10px 20px;
    border-radius: 6px;
    font-weight: 500;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary {
    background: var(--primary-blue);
    border: 1px solid var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background: var(--dark-blue);
    border-color: var(--dark-blue);
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 20px;
    }
    
    .color-picker-container,
    .range-group {
        flex-direction: column;
        align-items: flex-start;
    }
}
</style>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0"><i class="fas fa-comment-alt me-2"></i>Editor de Mensagem de Texto</h4>
                </div>
                <div class="card-body">
                    <form action="salvar_mensagem.php" method="post" id="messageForm">
                        <!-- Message Input -->
                        <div class="form-group">
                            <label for="mensagem" class="form-label">Texto da Mensagem</label>
                            <input type="text" class="form-control" id="mensagem" name="mensagem" 
                                   value="<?php echo $mensagem; ?>" required
                                   placeholder="Digite sua mensagem aqui">
                        </div>

                        <!-- Color Settings -->
                        <div class="form-group">
                            <label class="form-label">Configurações de Cor</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="cor" class="form-label">Cor do Texto</label>
                                    <input type="text" class="form-control mb-2" id="cor" name="cor" 
                                           value="<?php echo $cor; ?>" required readonly>
                                    <div class="color-picker-container">
                                        <div id="cor-picker" class="pickr"></div>
                                        <div class="color-preview-box" id="text-color-preview" 
                                             style="background-color: <?php echo $cor; ?>"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="bgcolor" class="form-label">Cor de Fundo</label>
                                    <input type="text" class="form-control mb-2" id="bgcolor" name="bgcolor" 
                                           value="<?php echo $bgcolor; ?>" required readonly>
                                    <div class="color-picker-container">
                                        <div id="bgcolor-picker" class="pickr"></div>
                                        <div class="color-preview-box" id="bg-color-preview"
                                             style="background-color: <?php echo $bgcolor; ?>"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Appearance Settings -->
                        <div class="form-group">
                            <label class="form-label">Ajustes de Aparência</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="opacity" class="form-label">Opacidade</label>
                                    <div class="range-group">
                                        <input type="range" class="range-slider" id="opacity" name="opacity" 
                                               min="0" max="1" step="0.1" value="<?php echo $opacity; ?>" required>
                                        <span class="range-value" id="opacityValue"><?php echo $opacity; ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="fontSize" class="form-label">Tamanho da Fonte (px)</label>
                                    <div class="range-group">
                                        <input type="number" class="form-control" id="fontSize" name="fontSize" 
                                               min="8" max="72" value="<?php echo $fontSize; ?>" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Preview Section -->
                        <div class="preview-section">
                            <div class="preview-header">
                                <h5 class="preview-title"><i class="fas fa-eye me-2"></i>Pré-visualização</h5>
                            </div>
                            <div class="preview-content">
                                <div class="preview-text" id="live-preview"
                                     style="color: <?php echo $cor; ?>;
                                            background-color: <?php echo $bgcolor; ?>;
                                            opacity: <?php echo $opacity; ?>;
                                            font-size: <?php echo $fontSize; ?>px">
                                    <?php echo $mensagem; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include Pickr CSS and JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@simonwep/pickr/dist/themes/classic.min.css" />
<script src="https://cdn.jsdelivr.net/npm/@simonwep/pickr"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize color pickers
    const pickrTextColor = Pickr.create({
        el: '#cor-picker',
        theme: 'classic',
        default: '<?php echo $cor; ?>',
        components: {
            preview: true,
            opacity: true,
            hue: true,
            interaction: {
                hex: true,
                rgba: true,
                input: true,
                save: true
            }
        }
    });

    const pickrBgColor = Pickr.create({
        el: '#bgcolor-picker',
        theme: 'classic',
        default: '<?php echo $bgcolor; ?>',
        components: {
            preview: true,
            opacity: true,
            hue: true,
            interaction: {
                hex: true,
                rgba: true,
                input: true,
                save: true
            }
        }
    });

    // Update when colors change
    pickrTextColor.on('save', (color) => {
        const hexColor = color.toHEXA().toString();
        document.getElementById('cor').value = hexColor;
        document.getElementById('text-color-preview').style.backgroundColor = hexColor;
        updateLivePreview();
    });

    pickrBgColor.on('save', (color) => {
        const hexColor = color.toHEXA().toString();
        document.getElementById('bgcolor').value = hexColor;
        document.getElementById('bg-color-preview').style.backgroundColor = hexColor;
        updateLivePreview();
    });

    // Real-time updates
    document.getElementById('opacity').addEventListener('input', function() {
        document.getElementById('opacityValue').textContent = this.value;
        updateLivePreview();
    });

    document.getElementById('fontSize').addEventListener('input', updateLivePreview);
    document.getElementById('mensagem').addEventListener('input', updateLivePreview);

    // Live preview update function
    function updateLivePreview() {
        const preview = document.getElementById('live-preview');
        preview.textContent = document.getElementById('mensagem').value;
        preview.style.color = document.getElementById('cor').value;
        preview.style.backgroundColor = document.getElementById('bgcolor').value;
        preview.style.opacity = document.getElementById('opacity').value;
        preview.style.fontSize = document.getElementById('fontSize').value + 'px';
    }

    // Initial update
    updateLivePreview();
});
</script>

<?php 
include 'includes/footer.php';
?>